<?php
// ═══════════════════════════════════════════════════════
// 📦 بارگذاری فایل‌های مورد نیاز
// ═══════════════════════════════════════════════════════

// تنظیم مسیر صحیح فایل‌ها
require_once __DIR__ . '/config.php';       // تنظیمات اصلی و دیتابیس
require_once __DIR__ . '/functions.php';    // توابع مشترک
require_once __DIR__ . '/jdate.php';        // تبدیل تاریخ شمسی

// سیستم‌های اصلی
require_once __DIR__ . '/khan.php';         // سیستم اصلی ربات
require_once __DIR__ . '/mir.php';          // مقامات و مدیریت
require_once __DIR__ . '/mia.php';          // قفل‌ها
require_once __DIR__ . '/me.php';           // کاربری
require_once __DIR__ . '/n.php';            // نجوا
require_once __DIR__ . '/p.php';            // آنتی پورن

// 🔧 اصلاح خطای فایل pv.php
if (file_exists(__DIR__ . '/pv.php')) {
    require_once __DIR__ . '/pv.php';
} else {
    // توابع جایگزین برای جلوگیری از ارور
    if (!function_exists('handlePvStart')) {
        function handlePvStart($update) {
            $chatId = $update['message']['chat']['id'] ?? 0;
            if (function_exists('sendMessage') && $chatId) {
                sendMessage($chatId, "⚠️ سیستم پنل کاربری (PV) موقتاً در دسترس نیست (فایل pv.php یافت نشد).");
            }
        }
    }
    if (!function_exists('handlePvCallback')) {
        function handlePvCallback($update) {
            $cbId = $update['callback_query']['id'] ?? 0;
            if (function_exists('answerCallbackQuery') && $cbId) {
                answerCallbackQuery($cbId, "⚠️ فایل سیستمی یافت نشد.", true);
            }
        }
    }
}

// 🛠 اصلاح هوشمند و تضمینی دیتابیس (رفع ارور lock_porn)
function ensureDatabaseColumns() {
    try {
        $db = Database::instance()->pdo();
        
        // 1. بررسی وجود جدول groups_data
        $tableExists = $db->query("SHOW TABLES LIKE 'groups_data'")->rowCount() > 0;
        
        if (!$tableExists) {
            // ساخت جدول اگر اصلاً وجود ندارد
            $db->exec("CREATE TABLE IF NOT EXISTS groups_data (
                group_id BIGINT PRIMARY KEY,
                group_title VARCHAR(255),
                is_active TINYINT(1) DEFAULT 0,
                expire_date DATETIME,
                lock_porn TINYINT(1) DEFAULT 0,
                lock_link TINYINT(1) DEFAULT 0,
                lock_fwd TINYINT(1) DEFAULT 0,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            return;
        }

        // 2. بررسی ستون‌های موجود
        $stmt = $db->prepare("SHOW COLUMNS FROM groups_data");
        $stmt->execute();
        $existingColumns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        // لیست ستون‌های مورد نیاز برای اضافه کردن
        $neededColumns = [
            'lock_porn' => 'TINYINT(1) DEFAULT 0',
            'lock_link' => 'TINYINT(1) DEFAULT 0',
            'lock_fwd'  => 'TINYINT(1) DEFAULT 0'
        ];

        foreach ($neededColumns as $colName => $colDef) {
            // اگر ستون در لیست نبود، اضافه کن
            if (!in_array($colName, $existingColumns)) {
                $db->exec("ALTER TABLE groups_data ADD COLUMN $colName $colDef");
            }
        }
        
    } catch (Exception $e) {
        // لاگ خطا بدون متوقف کردن ربات
        error_log("DB Fix Error: " . $e->getMessage());
    }
}
ensureDatabaseColumns(); // اجرای تعمیر دیتابیس

// تنظیم timezone
date_default_timezone_set('Asia/Tehran');

// ═══════════════════════════════════════════════════════
// 📥 دریافت آپدیت از تلگرام
// ═══════════════════════════════════════════════════════
$update = json_decode(file_get_contents('php://input'), true);

// ═══════════════════════════════════════════════════════
// 📝 لاگ آپدیت‌ها (برای دیباگ)
// ═══════════════════════════════════════════════════════
if ($update) {
    if (!file_exists('logs')) {
        mkdir('logs', 0755, true);
    }
    
    file_put_contents(
        'logs/updates_' . date('Y-m-d') . '.log',
        date('H:i:s') . ' - ' . json_encode($update, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT) . "\n",
        FILE_APPEND
    );
}
// ═══════════════════════════════════════════════════════
// 🚀 پردازش آپدیت
// ═══════════════════════════════════════════════════════
if ($update) {
    processUpdate($update);
}

/**
 * ═══════════════════════════════════════════════════════
 * 🔄 تابع اصلی پردازش آپدیت
 * ═══════════════════════════════════════════════════════
 */
function processUpdate(array $update): void
{
    // 💬 پیام عادی
    if (isset($update['message'])) {
        $message = $update['message'];
        $chat = $message['chat'];
        
        // تشخیص نوع چت
        if ($chat['type'] == 'private') {
            handlePrivateMessage($message, $update);
        } elseif (in_array($chat['type'], ['group', 'supergroup'])) {
            handleGroupMessage($message);
        }
    }
    
    // 🔘 کالبک کوئری
    if (isset($update['callback_query'])) {
        handleCallback($update['callback_query']);
    }
    
    // 👥 عضو جدید گروه
    if (isset($update['message']['new_chat_members'])) {
        handleNewMembers($update['message']);
    }
    
    // 👋 خروج عضو از گروه
    if (isset($update['message']['left_chat_member'])) {
        handleLeftMember($update['message']);
    }
    
    // 🔄 تغییر در چت (ربات اضافه/حذف شد)
    if (isset($update['my_chat_member'])) {
        handleChatMemberUpdate($update['my_chat_member']);
    }
}

/**
 * ═══════════════════════════════════════════════════════
 * 💬 مدیریت پیام‌های خصوصی (PV)
 * ═══════════════════════════════════════════════════════
 */
function handlePrivateMessage(array $message, array $update): void
{
    $chatId = $message['chat']['id'];
    $from = $message['from'];
    $text = trim($message['text'] ?? '');
    $messageId = $message['message_id'];
    
    // ═══════════════════════════════════════════════════════
    // 🎯 دستور /start
    // ═══════════════════════════════════════════════════════
    if ($text === '/start') {
        // بررسی پارامتر start برای نجوا
        if (strpos($text, ' ') !== false) {
            $parts = explode(' ', $text, 2);
            $startParam = $parts[1];
            
            // پردازش start نجوا
            if (strpos($startParam, 'w_') === 0) {
                handleWhisperStart($from['id'], $startParam);
                return;
            }
        }
        
        // نمایش پنل اصلی PV
        handlePvStart($update);
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 📝 بررسی حالت نوشتن نجوا
    // ═══════════════════════════════════════════════════════
    if (processWhisperText($message)) {
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 🎁 ساخت کد گیفت (فقط سودو)
    // ═══════════════════════════════════════════════════════
    if ($from['id'] == SUDO_ID && preg_match('/^!ساخت\s+(\d+)$/u', $text, $matches)) {
        $days = intval($matches[1]);
        
        if ($days < 1 || $days > 365) {
            sendMessage($chatId, "❌ تعداد روز باید بین 1 تا 365 باشد!", null, $messageId);
            return;
        }
        
        $code = generateGiftCode($days, $from['id']);
        
        $response = "✅ <b>کد گیفت با موفقیت ساخته شد</b>\n\n";
        $response .= "🎁 <b>کد:</b> <code>{$code}</code>\n";
        $response .= "⏳ <b>مدت:</b> {$days} روز\n";
        $response .= "📅 <b>تاریخ ساخت:</b> " . jdate('Y/m/d H:i') . "\n\n";
        $response .= "برای استفاده از این کد در گروه:\n";
        $response .= "<code>!گیفت {$code}</code>";
        
        sendMessage($chatId, $response, null, $messageId);
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 📖 راهنما و پیام پیش‌فرض
    // ═══════════════════════════════════════════════════════
    $help = "📖 <b>راهنمای استفاده از ربات خان بابا</b>\n\n";
    $help .= "لطفاً ربات را به گروه خود اضافه کنید تا از امکانات آن استفاده کنید.\n\n";
    
    $help .= "<b>🔹 دستورات اصلی در گروه:</b>\n";
    $help .= "• <code>!اعتبار</code> - مشاهده اعتبار باقیمانده\n";
    $help .= "• <code>!شارژ</code> - درخواست شارژ گروه\n";
    $help .= "• <code>!پیکربندی</code> - تنظیمات گروه\n";
    $help .= "• <code>!گیفت [کد]</code> - فعال‌سازی با کد گیفت\n\n";
    
    $help .= "<b>👮 سیستم MIR (مقامات):</b>\n";
    $help .= "• تنظیم/حذف: مالک، معاون، مشاور، مدیر، ویژه\n";
    $help .= "• بن/سکوت/اخطار کاربران\n";
    $help .= "• <code>پنل کاربر</code> - مدیریت دسترسی‌ها\n\n";
    
    $help .= "<b>🔒 سیستم MIA (قفل‌ها):</b>\n";
    $help .= "• <code>قفل‌ها</code> - پنل مدیریت قفل‌ها\n";
    $help .= "• قفل/باز کردن: لینک، فوروارد، استیکر، گیف و...\n\n";
    
    $help .= "<b>👤 سیستم ME (کاربری):</b>\n";
    $help .= "• آیدی، لقب، اصل، تگ\n";
    $help .= "• بیو، فونت، لینک، ساعت\n";
    $help .= "• سنجاق، تنظیم عکس\n\n";
    
    $help .= "<b>🤫 سیستم N (نجوا):</b>\n";
    $help .= "• <code>نجوا</code> - ارسال پیام محرمانه (فقط مقامداران)\n\n";
    
    $help .= "<b>🔞 سیستم P (آنتی پورن):</b>\n";
    $help .= "• تشخیص خودکار با Google AI\n";
    $help .= "• <code>قفل پورن</code> - فعال‌سازی (فقط سودو)\n\n";
    
    if ($from['id'] == SUDO_ID) {
        $help .= "<b>👨‍💻 دستورات سودو:</b>\n";
        $help .= "• <code>!ساخت [روز]</code> - ساخت کد گیفت\n";
        $help .= "• <code>!بن+</code> - بن سراسری\n";
        $help .= "• <code>!Add</code> - نصب ربات در گروه\n";
        $help .= "• <code>!ریست</code> - ریست کردن گروه\n";
        $help .= "• <code>!ترک</code> - خروج از گروه\n\n";
    }
    
    $help .= "💡 <b>نکته:</b> برای دریافت راهنمای کامل، ربات را به گروه اضافه کنید.";
    
    sendMessage($chatId, $help, null, $messageId);
}

/**
 * ═══════════════════════════════════════════════════════
 * 👥 مدیریت پیام‌های گروه
 * ═══════════════════════════════════════════════════════
 * 
 * اولویت پردازش (مهم - به ترتیب):
 * 1. ذخیره اطلاعات کاربر (MIR)
 * 2. بررسی بن سراسری (MIR) - بالاترین اولویت
 * 3. اسکن پورن (P) - اجرا در پس‌زمینه
 * 4. دستورات ME (کاربری)
 * 5. بررسی قفل‌های MIA
 * 6. دستورات قفل پورن (P)
 * 7. دستورات نجوا (N)
 * 8. دستورات MIA (قفل‌ها)
 * 9. دستورات MIR (مدیریتی)
 * 10. دستورات Khan (سیستم اصلی)
 */
function handleGroupMessage(array $message): void
{
    $chatId = $message['chat']['id'];
    $from = $message['from'];
    $text = trim($message['text'] ?? '');
    
    // ═══════════════════════════════════════════════════════
    // 🔐 اولویت 0: ذخیره اطلاعات کاربر در MIR
    // ═══════════════════════════════════════════════════════
    $mir = new MirSystem($message);
    $mir->saveUserInfo($from);
    
    // ═══════════════════════════════════════════════════════
    // 🚨 اولویت 1: بررسی بن سراسری (MIR)
    // ═══════════════════════════════════════════════════════
    // اگر کاربر در لیست بن سراسری است، خودکار بن می‌شود و پردازش متوقف می‌شود
    if ($mir->checkGlobalBan($from['id'])) {
        return; // کاربر بن سراسری است - هیچ پردازش دیگری انجام نمی‌شود
    }
    
    // ═══════════════════════════════════════════════════════
    // 🔞 اولویت 2: اسکان پورن (P) - در پس‌زمینه
    // ═══════════════════════════════════════════════════════
    // این در پس‌زمینه اجرا می‌شود و پردازش را متوقف نمی‌کند
    // ✅ با try-catch تا اگر ارور دیتابیس بود، کل ربات نمیرد
    try {
        processPornScan($message);
    } catch (Throwable $e) {
        // لاگ کردن خطا اما ادامه دادن اجرای ربات
        error_log("Porn Scan Logic Error: " . $e->getMessage());
    }
    
    // ═══════════════════════════════════════════════════════
    // 👤 اولویت 3: دستورات ME (کاربری)
    // ═══════════════════════════════════════════════════════
    if (processMeCommand($message)) {
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 🔒 اولویت 4: بررسی قفل‌های MIA
    // ═══════════════════════════════════════════════════════
    // بررسی محتوای پیام - اگر قفل باشد، پیام حذف می‌شود
    if (checkMiaMessage($message)) {
        return; // پیام حذف شد بخاطر قفل
    }
    
    // ═══════════════════════════════════════════════════════
    // 🔞 اولویت 5: دستورات قفل پورن (P)
    // ═══════════════════════════════════════════════════════
    if (processPornCommand($message)) {
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 🤫 اولویت 6: دستورات نجوا (N)
    // ═══════════════════════════════════════════════════════
    if (processWhisperCommand($message)) {
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 🔒 اولویت 7: دستورات MIA (قفل‌ها)
    // ═══════════════════════════════════════════════════════
    if (processMiaCommand($message)) {
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 👮 اولویت 8: دستورات MIR (مدیریتی)
    // ═══════════════════════════════════════════════════════
    // لیست دستورات MIR
    $mirCommands = [
        // مالک
        'تنظیم مالک', 'ارتقا مالک', 'حذف مالک', 'عزل مالک', 'لیست مالکین', 'لیست مالک',
        // معاون
        'تنظیم معاون', 'ارتقا معاون', 'حذف معاون', 'عزل معاون', 'لیست معاون', 'لیست معاونین',
        // مشاور
        'تنظیم مشاور', 'ارتقا مشاور', 'حذف مشاور', 'عزل مشاور', 'لیست مشاور', 'لیست مشاورین',
        // مدیر
        'تنظیم مدیر', 'ارتقا مدیر', 'حذف مدیر', 'عزل مدیر', 'لیست مدیران', 'لیست مدیر',
        // ویژه
        'تنظیم ویژه', 'ارتقا ویژه', 'حذف ویژه', 'عزل ویژه', 'لیست ویژه',
        // بن
        'بن', 'حذف بن', 'لیست بن',
        // بن سراسری
        'بن+', '!بن', '!حذف بن',
        // سکوت
        'سکوت', 'حذف سکوت', 'لیست سکوت',
        // اخطار
        'اخطار', 'حذف اخطار', 'حذف اخطارها', 'لیست اخطار',
        // پنل
        'پنل کاربر'
    ];
    
    // بررسی دستور پایه
    $isMirCommand = in_array($text, $mirCommands);
    
    // بررسی دستورات با پارامتر
    if (!$isMirCommand) {
        $patterns = [
            '/^(تنظیم|ارتقا|حذف|عزل)\s*(مالک|معاون|مشاور|مدیر|ویژه)/u',
            '/^(بن|حذف\s*بن|سکوت|حذف\s*سکوت|اخطار|حذف\s*اخطار|حذف\s*اخطارها)/u',
            '/^(بن\+|!بن|!حذف\s*بن)/u',
            '/^پنل\s*کاربر/u',
            '/^تعداد\s*اخطار\s*\d+$/u'
        ];
        
        foreach ($patterns as $pattern) {
            if (preg_match($pattern, $text)) {
                $isMirCommand = true;
                break;
            }
        }
    }
    
    if ($isMirCommand) {
        processMirCommand($message);
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 🤖 اولویت 9: دستورات Khan (سیستم اصلی)
    // ═══════════════════════════════════════════════════════
    $khan = new Khan($message);
    $khan->process();
}

/**
 * ═══════════════════════════════════════════════════════
 * 🔘 مدیریت کالبک‌ها
 * ═══════════════════════════════════════════════════════
 */
function handleCallback(array $callback): void
{
    global $update;
    $data = $callback['data'] ?? '';
    $message = $callback['message'];
    $from = $callback['from'];
    $chatId = $message['chat']['id'];
    $messageId = $message['message_id'];
    $callbackId = $callback['id'];
    
    // پاسخ اولیه به کالبک
    answerCallbackQuery($callbackId, '⏳ در حال پردازش...');
    
    // ═══════════════════════════════════════════════════════
    // 👮 کالبک‌های سیستم MIR (پنل مدیریتی)
    // ═══════════════════════════════════════════════════════
    if (strpos($data, 'panel_') === 0) {
        if (handleMirCallback($callback)) {
            return;
        }
    }
    
    // ═══════════════════════════════════════════════════════
    // 🔒 کالبک‌های سیستم MIA (قفل‌ها)
    // ═══════════════════════════════════════════════════════
    if (strpos($data, 'mia_') === 0) {
        if (handleMiaCallback($callback)) {
            return;
        }
    }
    
    // ═══════════════════════════════════════════════════════
    // 👤 کالبک‌های ME (تگ و سایر)
    // ═══════════════════════════════════════════════════════
    if (strpos($data, 'me_') === 0) {
        if (handleMeCallback($callback)) {
            return;
        }
    }
    
    // ═══════════════════════════════════════════════════════
    // 🤫 کالبک‌های نجوا (N)
    // ═══════════════════════════════════════════════════════
    if (strpos($data, 'n_') === 0) {
        if (processWhisperCallback($callback)) {
            return;
        }
    }
    
    // ═══════════════════════════════════════════════════════
    // 💬 کالبک‌های پنل خصوصی (PV)
    // ═══════════════════════════════════════════════════════
    if (in_array($data, ['pv_home', 'pv_help', 'pv_install', 'pv_creator', 'pv_account'])) {
        handlePvCallback($update);
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 📨 درخواست نصب ربات
    // ═══════════════════════════════════════════════════════
    if ($data === 'request_install') {
        $db = Database::instance()->pdo();
        
        // دریافت اطلاعات گروه
        $stmt = $db->prepare("SELECT group_title FROM groups_data WHERE group_id = ?");
        $stmt->execute([$chatId]);
        $groupData = $stmt->fetch();
        $groupTitle = $groupData ? $groupData['group_title'] : $message['chat']['title'];
        
        // پیام برای سودو
        $sudoText = "🔔 <b>درخواست نصب ربات جدید!</b>\n\n";
        $sudoText .= "👥 <b>نام گروه:</b> " . htmlspecialchars($groupTitle) . "\n";
        $sudoText .= "🆔 <b>شناسه:</b> <code>{$chatId}</code>\n";
        $sudoText .= "👤 <b>درخواست‌کننده:</b> " . getUserMention($from) . "\n";
        $sudoText .= "📅 <b>تاریخ:</b> " . jdate('Y/m/d H:i') . "\n\n";
        $sudoText .= "برای نصب ربات، به گروه بروید و دستور <code>!Add</code> را بزنید.";
        
        // دکمه ورود به گروه
        $sudoKeyboard = null;
        if (!empty($message['chat']['username'])) {
            $groupLink = "https://t.me/" . $message['chat']['username'];
            $sudoKeyboard = [
                'inline_keyboard' => [
                    [['text' => '🔗 ورود به گروه', 'url' => $groupLink]]
                ]
            ];
        } else {
            $inviteLink = tgRequest('exportChatInviteLink', ['chat_id' => $chatId]);
            if ($inviteLink && isset($inviteLink['result'])) {
                $sudoKeyboard = [
                    'inline_keyboard' => [
                        [['text' => '🔗 لینک دعوت گروه', 'url' => $inviteLink['result']]]
                    ]
                ];
            }
        }
        
        // ارسال به سودو
        sendMessage(SUDO_ID, $sudoText, $sudoKeyboard);
        
        // پیام تایید
        $confirmText = "✅ <b>درخواست شما ارسال شد!</b>\n\n";
        $confirmText .= "درخواست نصب ربات به مدیریت ارسال شد.\n";
        $confirmText .= "لطفاً منتظر فعال‌سازی بمانید.\n\n";
        $confirmText .= "⏱ معمولاً ظرف چند دقیقه فعال می‌شود.";
        
        editMessage($chatId, $messageId, $confirmText);
        answerCallbackQuery($callbackId, '✅ درخواست ارسال شد!');
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 🟢 نصب 7 روزه
    // ═══════════════════════════════════════════════════════
    if ($data === 'install_7days' && $from['id'] === SUDO_ID) {
        $db = Database::instance()->pdo();
        $stmt = $db->prepare("SELECT group_title FROM groups_data WHERE group_id = ?");
        $stmt->execute([$chatId]);
        $groupData = $stmt->fetch();
        $groupTitle = $groupData ? $groupData['group_title'] : $message['chat']['title'];
        
        activateGroup($chatId, 7, $groupTitle);
        
        $text = "✅ <b>گروه با موفقیت نصب شد</b>\n\n";
        $text .= "⏳ <b>مدت اعتبار:</b> 7 روز\n";
        $text .= "📅 <b>تاریخ انقضا:</b> " . jdate('Y/m/d', strtotime('+7 days')) . "\n\n";
        $text .= "ربات اکنون در این گروه فعال است! 🎉";
        
        editMessage($chatId, $messageId, $text);
        answerCallbackQuery($callbackId, '✅ نصب شد!');
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // 🔵 نصب 30 روزه
    // ═══════════════════════════════════════════════════════
    if ($data === 'install_30days' && $from['id'] === SUDO_ID) {
        $db = Database::instance()->pdo();
        $stmt = $db->prepare("SELECT group_title FROM groups_data WHERE group_id = ?");
        $stmt->execute([$chatId]);
        $groupData = $stmt->fetch();
        $groupTitle = $groupData ? $groupData['group_title'] : $message['chat']['title'];
        
        activateGroup($chatId, 30, $groupTitle);
        
        $text = "✅ <b>گروه با موفقیت نصب شد</b>\n\n";
        $text .= "⏳ <b>مدت اعتبار:</b> 30 روز\n";
        $text .= "📅 <b>تاریخ انقضا:</b> " . jdate('Y/m/d', strtotime('+30 days')) . "\n\n";
        $text .= "ربات اکنون در این گروه فعال است! 🎉";
        
        editMessage($chatId, $messageId, $text);
        answerCallbackQuery($callbackId, '✅ نصب شد!');
        return;
    }
    
    // ═══════════════════════════════════════════════════════
    // ❌ بستن پنل
    // ═══════════════════════════════════════════════════════
    if ($data === 'close_panel') {
        editMessage($chatId, $messageId, "✅ <b>پنل بسته شد</b>");
        answerCallbackQuery($callbackId, 'پنل بسته شد');
    }
}

/**
 * ═══════════════════════════════════════════════════════
 * 👥 مدیریت اعضای جدید
 * ═══════════════════════════════════════════════════════
 */
function handleNewMembers(array $message): void
{
    $newMembers = $message['new_chat_members'];
    $chat = $message['chat'];
    
    foreach ($newMembers as $member) {
        // اگر ربات به گروه اضافه شد
        if (isset($member['username']) && $member['username'] === str_replace('@', '', BOT_USERNAME)) {
            // ✅ اصلاح: چک کردن وجود title
            $title = $chat['title'] ?? 'Unknown Group';
            checkGroupStatus($chat['id'], $title);
        }
    }
}

/**
 * ═══════════════════════════════════════════════════════
 * 👋 مدیریت خروج عضو - با حذف اطلاعات ME
 * ═══════════════════════════════════════════════════════
 */
function handleLeftMember(array $message): void
{
    $leftMember = $message['left_chat_member'];
    $chatId = $message['chat']['id'];
    $userId = $leftMember['id'];
    
    // حذف اطلاعات کاربر از سیستم ME
    deleteUserData($chatId, $userId);
    
    // لاگ خروج
    logMessage("User {$userId} left chat {$chatId} - ME data deleted");
}

/**
 * ═══════════════════════════════════════════════════════
 * 🔄 مدیریت تغییرات عضویت چت
 * ═══════════════════════════════════════════════════════
 */
function handleChatMemberUpdate(array $update): void
{
    $chat = $update['chat'];
    $newMember = $update['new_chat_member'];
    
    // ✅ اصلاح: اطمینان از وجود تایتل (جلوگیری از ارور fatal)
    $title = $chat['title'] ?? 'Group ' . $chat['id'];

    // اگر ربات به گروه اضافه شد
    if (in_array($newMember['status'], ['member', 'administrator'])) {
        checkGroupStatus($chat['id'], $title);
    }
    
    // اگر ربات از گروه حذف شد یا ترک کرد
    if (in_array($newMember['status'], ['kicked', 'left'])) {
        // حذف کامل اطلاعات گروه
        deleteGroupData($chat['id']);
        
        // اطلاع به سودو
        $text = "🗑 <b>ربات از گروه خارج شد</b>\n\n";
        $text .= "👥 <b>نام گروه:</b> " . htmlspecialchars($title) . "\n";
        $text .= "🆔 <b>شناسه:</b> <code>{$chat['id']}</code>\n";
        $text .= "📅 <b>تاریخ:</b> " . jdate('Y/m/d H:i') . "\n\n";
        $text .= "✅ تمام اطلاعات گروه از دیتابیس حذف شد.";
        
        sendMessage(SUDO_ID, $text);
    }
}

// ═══════════════════════════════════════════════════════
// 🎉 پایان فایل - ربات آماده است!
// ═══════════════════════════════════════════════════════
?>