<?php
/**
 * تنظیمات اصلی ربات خان بابا
 */

/*--------------------------------------------------
| تنظیمات ربات
--------------------------------------------------*/
define('BOT_TOKEN', '8478335569:AAGfbhZ4w5w_2IYvTG20CkLEIk-znZAep7o');
define('BOT_USERNAME', '@MirX9Bot');
define('SUDO_ID', 8396860881);

/*--------------------------------------------------
| تنظیمات دیتابیس
--------------------------------------------------*/
define('DB_HOST', 'localhost');
define('DB_NAME', 'khanir_khanir_a');
define('DB_USER', 'khanir_khanir_a1');
define('DB_PASS', 'Ebrahim1378*');
define('DB_CHARSET', 'utf8mb4');

/*--------------------------------------------------
| کلاس دیتابیس (Singleton)
--------------------------------------------------*/
final class Database
{
    private static ?Database $instance = null;
    private PDO $connection;

    private function __construct()
    {
        try {
            $dsn = sprintf(
                "mysql:host=%s;dbname=%s;charset=%s",
                DB_HOST,
                DB_NAME,
                DB_CHARSET
            );

            $this->connection = new PDO($dsn, DB_USER, DB_PASS, [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
            ]);
        } catch (PDOException $e) {
            error_log('[DB ERROR] ' . $e->getMessage());
            exit('خطای سیستمی در اتصال به دیتابیس');
        }
    }

    public static function instance(): Database
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function pdo(): PDO
    {
        return $this->connection;
    }
}

/*--------------------------------------------------
| ساخت جداول دیتابیس
--------------------------------------------------*/
function migrateDatabase(): void
{
    $db = Database::instance()->pdo();

    // جدول گروه‌ها
    $db->exec("
        CREATE TABLE IF NOT EXISTS groups_data (
            id INT AUTO_INCREMENT PRIMARY KEY,
            group_id BIGINT NOT NULL UNIQUE,
            group_title VARCHAR(255) NOT NULL,
            is_active TINYINT(1) DEFAULT 0,
            expire_date DATETIME DEFAULT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX (group_id),
            INDEX (is_active),
            INDEX (expire_date)
        ) ENGINE=InnoDB CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // جدول ادمین‌ها
    $db->exec("
        CREATE TABLE IF NOT EXISTS group_admins (
            id INT AUTO_INCREMENT PRIMARY KEY,
            group_id BIGINT NOT NULL,
            user_id BIGINT NOT NULL,
            username VARCHAR(255) DEFAULT NULL,
            first_name VARCHAR(255) DEFAULT NULL,
            is_creator TINYINT(1) DEFAULT 0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            UNIQUE KEY unique_admin (group_id, user_id),
            INDEX (group_id),
            INDEX (user_id)
        ) ENGINE=InnoDB CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // جدول کدهای گیفت
    $db->exec("
        CREATE TABLE IF NOT EXISTS gift_codes (
            id INT AUTO_INCREMENT PRIMARY KEY,
            code VARCHAR(120) UNIQUE NOT NULL,
            days INT NOT NULL,
            is_used TINYINT(1) DEFAULT 0,
            used_by_group BIGINT DEFAULT NULL,
            used_at DATETIME DEFAULT NULL,
            created_by BIGINT NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            INDEX (code),
            INDEX (is_used)
        ) ENGINE=InnoDB CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // جدول تنظیمات
    $db->exec("
        CREATE TABLE IF NOT EXISTS settings (
            id INT AUTO_INCREMENT PRIMARY KEY,
            setting_key VARCHAR(100) UNIQUE NOT NULL,
            setting_value TEXT,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
}

// اجرای ساخت جداول
migrateDatabase();

/*--------------------------------------------------
| اطلاعات نسخه
--------------------------------------------------*/
define('BOT_META', [
    'version'     => '1.1.0',
    'last_update' => 1735689600
]);

// پایان فایل - هیچ تابعی اینجا تعریف نشده!
// همه توابع در functions.php هستن