<?php
session_start();
require_once 'Ebi.php';

// احراز هویت ساده
if (isset($_POST['login'])) {
    if ($_POST['password'] === PANEL_PASSWORD) {
        $_SESSION['logged_in'] = true;
    } else {
        $error = "رمز عبور اشتباه است!";
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: panel.php");
    exit;
}

if (!isset($_SESSION['logged_in'])) {
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <title>ورود به پنل مدیریت</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <style>body{background:#f0f2f5;display:flex;align-items:center;justify-content:center;height:100vh;font-family:Tahoma,sans-serif;}</style>
    </head>
    <body>
        <div class="card p-4 shadow" style="width: 350px;">
            <h4 class="text-center mb-4">🔐 ورود مدیر</h4>
            <?php if(isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
            <form method="post">
                <input type="password" name="password" class="form-control mb-3" placeholder="رمز عبور..." required>
                <button type="submit" name="login" class="btn btn-primary w-100">ورود</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// ══════════════ عملیات پنل ══════════════

$db = getDB();
$msg_alert = "";

// 1. ساخت کد شارژ
if (isset($_POST['create_code'])) {
    $days = (int)$_POST['days'];
    $code = "CHARGE-" . strtoupper(substr(md5(uniqid()), 0, 8));
    $stmt = $db->prepare("INSERT INTO charge_codes (code, days) VALUES (?, ?)");
    $stmt->execute([$code, $days]);
    $msg_alert = "✅ کد شارژ ساخته شد: $code ($days روزه)";
}

// 2. تمدید دستی گروه
if (isset($_POST['renew_group'])) {
    $gid = $_POST['group_id'];
    $days = (int)$_POST['days'];
    activateGroup($gid, $days);
    
    // ارسال اعلان سیستمی به گروه
    sendMessage($gid, "♻️ <b>اعلان سیستمی:</b>\n\nگروه شما توسط مدیریت به مدت <b>$days روز</b> تمدید شد. ✅");
    $msg_alert = "✅ گروه $gid تمدید شد و پیام ارسال گردید.";
}

// 3. غیرفعال کردن گروه
if (isset($_POST['deactivate_group'])) {
    $gid = $_POST['group_id'];
    deactivateGroup($gid);
    sendMessage($gid, "🚫 <b>اعلان سیستمی:</b>\n\nخدمات ربات برای این گروه توسط مدیریت قطع شد.");
    $msg_alert = "⛔️ گروه $gid غیرفعال شد.";
}

// 4. پیام همگانی
if (isset($_POST['broadcast'])) {
    $text = $_POST['bc_text'];
    $type = $_POST['bc_type']; // groups or users
    
    if ($type == 'groups') {
        $stmt = $db->query("SELECT id FROM `groups`");
        $ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
    } else {
        $stmt = $db->query("SELECT user_id FROM `user_globals`");
        $ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
    }
    
    $count = 0;
    foreach ($ids as $id) {
        $res = sendMessage($id, "📢 <b>پیام همگانی از مدیریت:</b>\n\n" . $text);
        if ($res['ok']) $count++;
    }
    $msg_alert = "✅ پیام به $count مورد ارسال شد.";
}

// ══════════════ دریافت داده‌ها ══════════════

// آمار کلی
$stats = [
    'groups' => $db->query("SELECT COUNT(*) FROM `groups`")->fetchColumn(),
    'users' => $db->query("SELECT COUNT(*) FROM `user_globals`")->fetchColumn(),
    'whispers' => $db->query("SELECT COUNT(*) FROM `whispers`")->fetchColumn(),
    'active_groups' => $db->query("SELECT COUNT(*) FROM `groups` WHERE is_active=1")->fetchColumn()
];

// لیست نجواها
$whispers = $db->query("SELECT * FROM whispers ORDER BY created_at DESC LIMIT 50")->fetchAll();

// لیست گروه‌ها
$groups = $db->query("SELECT * FROM `groups` ORDER BY activated_at DESC LIMIT 50")->fetchAll();

// لیست کدهای شارژ فعال
$codes = $db->query("SELECT * FROM charge_codes WHERE is_used=0 ORDER BY created_at DESC")->fetchAll();

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل مدیریت ربات</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{background-color:#f8f9fa;font-family:Tahoma,sans-serif;font-size:14px;}
        .card{margin-bottom:20px;box-shadow:0 2px 4px rgba(0,0,0,.05);border:none;}
        .table td{vertical-align:middle;}
        .copy-btn{cursor:pointer;}
    </style>
</head>
<body>
    
<nav class="navbar navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <span class="navbar-brand mb-0 h1">🤖 پنل مدیریت ربات</span>
    <a href="?logout=1" class="btn btn-danger btn-sm">خروج</a>
  </div>
</nav>

<div class="container">
    <?php if($msg_alert) echo "<div class='alert alert-success'>$msg_alert</div>"; ?>

    <!-- آمار -->
    <div class="row text-center mb-4">
        <div class="col-md-3"><div class="card p-3 bg-primary text-white"><h3><?php echo $stats['groups']; ?></h3><small>کل گروه‌ها</small></div></div>
        <div class="col-md-3"><div class="card p-3 bg-success text-white"><h3><?php echo $stats['active_groups']; ?></h3><small>گروه‌های فعال</small></div></div>
        <div class="col-md-3"><div class="card p-3 bg-warning text-white"><h3><?php echo $stats['users']; ?></h3><small>کاربران</small></div></div>
        <div class="col-md-3"><div class="card p-3 bg-info text-white"><h3><?php echo $stats['whispers']; ?></h3><small>نجواها</small></div></div>
    </div>

    <div class="row">
        <!-- مدیریت کدهای شارژ -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white fw-bold">🎫 مدیریت کدهای شارژ</div>
                <div class="card-body">
                    <form method="post" class="d-flex gap-2 mb-3">
                        <input type="number" name="days" class="form-control" placeholder="تعداد روز" required>
                        <button type="submit" name="create_code" class="btn btn-primary">ساخت کد</button>
                    </form>
                    <div style="max-height:200px;overflow-y:auto;">
                        <table class="table table-sm table-bordered">
                            <thead><tr><th>کد (کلیک برای کپی)</th><th>روز</th><th>عملیات</th></tr></thead>
                            <tbody>
                                <?php foreach($codes as $c): ?>
                                <tr>
                                    <td class="copy-btn text-primary" onclick="copyToClipboard('<?php echo $c['code']; ?>')"><?php echo $c['code']; ?></td>
                                    <td><?php echo $c['days']; ?></td>
                                    <td><span class="badge bg-success">فعال</span></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- ارسال پیام همگانی -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white fw-bold">📢 ارسال پیام همگانی</div>
                <div class="card-body">
                    <form method="post">
                        <textarea name="bc_text" class="form-control mb-2" rows="3" placeholder="متن پیام..." required></textarea>
                        <select name="bc_type" class="form-select mb-2">
                            <option value="groups">ارسال به تمام گروه‌ها</option>
                            <option value="users">ارسال به تمام کاربران (PV)</option>
                        </select>
                        <button type="submit" name="broadcast" class="btn btn-warning w-100">ارسال پیام</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- لیست گروه‌ها -->
    <div class="card">
        <div class="card-header bg-white fw-bold">👥 مدیریت گروه‌ها</div>
        <div class="card-body table-responsive">
            <table class="table table-hover">
                <thead><tr><th>نام گروه</th><th>شناسه</th><th>مالک</th><th>انقضا</th><th>عملیات</th></tr></thead>
                <tbody>
                    <?php foreach($groups as $g): 
                        $left = ceil((strtotime($g['expires_at']) - time()) / 86400);
                        $status_class = ($g['is_active'] && $left > 0) ? 'text-success' : 'text-danger';
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($g['title']); ?></td>
                        <td><small><?php echo $g['id']; ?></small></td>
                        <td><?php echo htmlspecialchars($g['owner_name']); ?></td>
                        <td class="<?php echo $status_class; ?>">
                            <?php echo ($left > 0) ? "$left روز مانده" : "منقضی"; ?>
                        </td>
                        <td>
                            <form method="post" class="d-flex gap-1">
                                <input type="hidden" name="group_id" value="<?php echo $g['id']; ?>">
                                <input type="number" name="days" value="30" style="width:60px;" class="form-control form-control-sm">
                                <button type="submit" name="renew_group" class="btn btn-sm btn-success">تمدید</button>
                                <button type="submit" name="deactivate_group" class="btn btn-sm btn-danger">قطع</button>
                                <!-- دکمه لینک: به دلیل محدودیت فنی وب، لینک را به تلگرام هدایت می‌کنیم -->
                                <a href="https://t.me/c/<?php echo substr($g['id'], 4); ?>/1" target="_blank" class="btn btn-sm btn-info">لینک</a>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- نجواهای اخیر -->
    <div class="card">
        <div class="card-header bg-white fw-bold">🤫 نجواهای اخیر</div>
        <div class="card-body table-responsive">
            <table class="table table-sm">
                <thead><tr><th>فرستنده</th><th>گیرنده</th><th>پیام</th><th>وضعیت</th></tr></thead>
                <tbody>
                    <?php foreach($whispers as $w): ?>
                    <tr>
                        <td><?php echo $w['sender_id']; ?></td>
                        <td><?php echo $w['receiver_id']; ?></td>
                        <td><?php echo htmlspecialchars($w['message']); ?></td>
                        <td><?php echo $w['status']; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('کد کپی شد: ' + text);
    }, function(err) {
        console.error('Async: Could not copy text: ', err);
    });
}
</script>

</body>
</html>